function updatePenalty(penaltyObject, numEle, timeEle) {
    const hp1 = penaltyObject.split(" ");;
    const hp1Num = hp1[0];
    const hp1Time = hp1[1];
    if (hp1Num) {
        numEle.text(hp1Num);
    } else {
        numEle.text("");
    }
    if (hp1Time) {
        timeEle.text(hp1Time);
    } else {
        timeEle.text("");
    }
}

function startConnection(host) {
    // Create WebSocket connection.
    var socket = new WebSocket('ws://'+host);

    // Connection opened
    socket.onopen = function(e) {
        console.log("[open] Connection established");
        console.log("Sending to server");
        socket.send("Hello, SlamScore");
    };

    // Listen for messages
    socket.onmessage = function(event) {
        const obj = event.data.split(";");
        console.log('Message from server ', obj);
        $("#time").text(obj[0] == "" ? "00:00" : obj[0]);
        $("#home-score").text(obj[1]);
        $("#guest-score").text(obj[2]);
        
        let period = obj[3];
        let gameTime = obj[12];
        // var periodStr = "";
        
        // if (period == "1") {
        //     periodStr = "1st"
        // } 
        // else if (period == "2") {
        //     periodStr = "2nd"
        // }
        // else if (period == "3") {
        //     periodStr = "3rd"
        // }
        // else if (period == "OT") {
        //     periodStr = "OT";
        // } 
        
        // if (gameTime == "SHO") {
        //     periodStr = "sho";
        // }
        
        $("#period").text(period);

        updatePenalty(obj[4], $("#home_penalty1_num"), $("#home_penalty1_time"));
        updatePenalty(obj[5], $("#home_penalty2_num"), $("#home_penalty2_time"));
        updatePenalty(obj[6], $("#guest_penalty1_num"), $("#guest_penalty1_time"));
        updatePenalty(obj[7], $("#guest_penalty2_num"), $("#guest_penalty2_time"));

        var homeTeamPenalty = obj[8];
        var guestTeamPenalty = obj[9];

        $("#gametime").text(gameTime);

        var homeLogo = obj[20]+"";
        var guestLogo = obj[21]+"";

        var homeLogoUrl = sedna_config["Home Logo URL"];
		var guestLogoUrl = sedna_config["Guest Logo URL"];

        var oldHomeLogo = $('#home_logo').attr('src');

        if (homeLogoUrl.length > 0) {
            $("#home_logo").attr('src', homeLogoUrl)
            $("#home_name").hide();
            $("#home_logo").show();
        }
        else if (homeLogo.length > 0) {
            if (homeLogo != oldHomeLogo) {
                $("#home_logo").attr('src', 'http://'+host+'/'+homeLogo);
            }
            $("#home_name").hide();
            $("#home_logo").show();
        } else {
            $("#home_name").show();
            $("#home_logo").hide();
        }
        var oldGuestLogo = $('#guest_logo').attr('src');
        if (guestLogoUrl.length > 0) {
            $("#guest_logo").attr('src', guestLogoUrl)
            $("#guest_name").hide();
            $("#guest_logo").show();
        }
        else if (guestLogo.length > 0) {
            $("#guest_name").hide();
            $("#guest_logo").show();
            if (guestLogo != oldGuestLogo) {
                $("#guest_logo").attr('src', 'http://'+host+'/'+guestLogo);
            }
        }
        else {
            $("#guest_name").show();
            $("#guest_logo").hide();
        }

        if (homeTeamPenalty == 1) {
            $("#home_team_penalty").css('visibility','')
        } else {
            $("#home_team_penalty").css('visibility','hidden')
        }

        if (guestTeamPenalty == 1) {
            $("#guest_team_penalty").css('visibility','')
        } else {
            $("#guest_team_penalty").css('visibility','hidden')
        }
    };
    
    socket.onclose = event => {
        console.log("event.code=", event.code);
        console.log("event.reason=", event.reason);
        console.log("event.wasClean=", event.wasClean);
        console.log("Try to reconnect in 3 seconds..");
        socket = null;
        // Try to reconnect in 3 seconds
        setTimeout(function(){startConnection(host)}, 3000);
    };
}